<?php
session_start();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if the checkbox was ticked
    if (isset($_POST['captcha_checkbox']) && $_POST['captcha_checkbox'] === 'on') {
        $_SESSION['captcha_verified'] = true; // Mark CAPTCHA as verified
        header("Location: visit.php"); // Redirect to index.html
        exit();
    } else {
        $error = "Please verify the checkbox to continue.";
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>CAPTCHA Verification</title>
</head>
<body>
    <h2>Verify You're Human</h2>
    <form method="post">
        <label>
            <input type="checkbox" name="captcha_checkbox"> I'm not a robot
        </label>
        <br><br>
        <button type="submit">Verify</button>
    </form>
    <?php if (isset($error)) echo "<p style='color:red;'>$error</p>"; ?>
</body>
</html>